<?php $__env->startSection('content'); ?>
    <form id="form-recyclingbijdrage" action="<?php echo e(route('recycling_contributions.store')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <div class="row">
            <div class="col-12">
                <h1 class="title-page">Overeenkomst voor de recyclingbijdrage</h1>
            </div>
        </div>
        <div class="row mt-3" id="success-block" style="display:none">
            <div class="col-12">
                <div class="alert alert-success">
                    Verzonden
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <!-- <p>
                    Welkom op de vernieuwde website voor oavaangifte.nl. Voordat u verder kunt, verzoeken wij u om onderstaande gegevens te controleren. Zijn deze correct dan hoeft u niets te doen. Zijn deze gegevens niet correct, dan kunt u ze hieronder wijzigen.
                </p> -->
                <?php if(session('success')): ?>
                    <div class="alert alert-success">
                        <?php echo e(session('success')); ?>

                    </div>
                <?php endif; ?>
            </div>
        </div>
        <div class="row mt-2">
            <div class="col-12">
                <iframe src="https://view.officeapps.live.com/op/view.aspx?src=<?php echo e(urlencode($outputUrl)); ?>" width="100%" height="600px"></iframe>
            </div>
        </div>
        <div class="row mt-2">
            <div class="col-md-3 col-12">
                <p>Rechtsgeldig vertegenwoordigd door</p>
            </div>
            <div class="col-md-6 col-12">
                <input type="text" id="contact_persoon" value="" name="contact_persoon" class="form-control can-change" />
                <div class="text-danger contact_persoon_error"></div>
            </div>
        </div>
        <div class="row mt-2 mb-2">
            <div class="col-md-3 col-12">
                <p>Handtekening</p>
            </div>
            <div class="col-md-6 col-12">
                <div id="signature-pad" class="signature-pad"></div>
            </div>
        </div>
        <div class="row mt-4 mb-4">
            <div class="col-12">
                <button type="button" class="btn btn-danger btn-sm" id="clear-signature" >Handtekening wissen</button>
                <button type="button" class="btn btn-primary btn-sm" id="send-request">Verzend verzoek</button>
            </div>
        </div>
    </form>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jSignature/2.1.3/jSignature.min.js" integrity="sha512-lZ7GJNAmaXw7L4bCR5ZgLFu12zSkuxHZGPJdIoAqP6lG+4eoSvwbmKvkyfauz8QyyzHGUGVHyoq/W+3gFHCLjA==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<style>
    .signature-pad {
        border: 2px dashed #ccc;
        width: 100%;
        max-width:500px;
        margin-bottom:10px;
    }
    button#send-request {
        float: right;
    }
</style>
<script>
    $(document).ready(function() {
        var signaturePad = $('#signature-pad').jSignature({ 'width': '100%', 'height': 200 });
        $('#clear-signature').click(function() {
            signaturePad.jSignature('reset');
        });
        $('#send-request').click(function() {
            var signatureData = signaturePad.jSignature('getData', 'image');
            $("#signature-image").attr("src", signatureData);
            let contact_persoon = jQuery('#contact_persoon').val();
            if(contact_persoon == ''){
                alert('Contactpersoon is verplicht')
                return false;
            }
            $.ajax({
                url: $('#form-recyclingbijdrage').attr('action'),
                type: "POST",
                data: {
                    _token: "<?php echo e(csrf_token()); ?>",
                    signature: signatureData,
                    contact_persoon: contact_persoon,
                },
                success: function(response) {
                    alert( response.message )
                    window.location.href = '/';
                },
                error: function() {
                    
                }
            });
        });
    });
</script>
<?php $__env->stopSection(); ?>














<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/oavaangifte/public_html/resources/views/front/recycling_contributions/create.blade.php ENDPATH**/ ?>