<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>">
<head>
	<?php echo $__env->make('includes.head', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</head>
<?php
	$bodyClass = (!empty($boxedLayout)) ? 'boxed-layout' : '';
	$bodyClass .= (!empty($paceTop)) ? 'pace-top ' : '';
	$bodyClass .= (!empty($bodyExtraClass)) ? $bodyExtraClass . ' ' : '';
	$sidebarHide = (!empty($sidebarHide)) ? $sidebarHide : '';
	$sidebarTwo = (!empty($sidebarTwo)) ? $sidebarTwo : '';
	$topMenu = (!empty($topMenu)) ? $topMenu : '';
	$footer = (!empty($footer)) ? $footer : '';
	
	$pageContainerClass = (!empty($topMenu)) ? 'page-with-top-menu ' : '';
	$pageContainerClass .= (!empty($sidebarRight)) ? 'page-with-right-sidebar ' : '';
	$pageContainerClass .= (!empty($sidebarLight)) ? 'page-with-light-sidebar ' : '';
	$pageContainerClass .= (!empty($sidebarWide)) ? 'page-with-wide-sidebar ' : '';
	$pageContainerClass .= (!empty($sidebarHide)) ? 'page-without-sidebar ' : '';
	$pageContainerClass .= (!empty($sidebarMinified)) ? 'page-sidebar-minified ' : '';
	$pageContainerClass .= (!empty($sidebarTwo)) ? 'page-with-two-sidebar ' : '';
	$pageContainerClass .= (!empty($contentFullHeight)) ? 'page-content-full-height ' : '';
	
	$contentClass = (!empty($contentFullWidth) || !empty($contentFullHeight)) ? 'content-full-width ' : '';
	$contentClass .= (!empty($contentInverseMode)) ? 'content-inverse-mode ' : '';
?>
<?php 
    $act = Route::getCurrentRoute()->getAction();  
    $routeName = Route::getCurrentRoute()->getName(); 
 ?>
<body class="<?php echo e($bodyClass); ?>" id="<?php echo $routeName;?>">
	<style>
	@media (min-width: 1200px){
		.container {
			max-width: 100% !important;
		}
	}
	</style>
	<?php echo $__env->make('includes.component.page-loader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
	
	<div id="page-container" class="page-container fade page-sidebar-fixed page-header-fixed <?php echo e($pageContainerClass); ?>">
		
		<?php echo $__env->make('includes.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
		
		<?php echo $__env->renderWhen($topMenu, 'includes.top-menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path'])); ?>
		
		<?php echo $__env->renderWhen(!$sidebarHide, 'includes.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path'])); ?>
		
		<?php echo $__env->renderWhen($sidebarTwo, 'includes.sidebar-right', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path'])); ?>
		
		<div id="content" class="content <?php echo e($contentClass); ?> print-area">
			<div class="panel panel-inverse">
				<div class="panel-body">
					<?php echo $__env->yieldContent('content'); ?>
				</div>
			</div>
		</div>
		
		<?php echo $__env->renderWhen($footer, 'includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path'])); ?>
		
		<?php echo $__env->make('includes.component.theme-panel', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
		
		<?php echo $__env->make('includes.component.scroll-top-btn', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
		
	</div>
	<div class="ajax-loading">
		<i class="fa fa-spinner fa-pulse fa-3x"></i>
	</div>
	<?php echo $__env->make('includes.page-js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>
</html>
<?php /**PATH /Users/thi/Local Sites/oavaangifte/resources/views/layouts/color_admin/default.blade.php ENDPATH**/ ?>