@extends('layouts.app')

@section('content')
    <form id="b-card-body-content" method="post" action="{{ route('home.postContact') }}">
        @csrf
        <div class="row">
            <div class="col-12">
                <h1 class="title-page">Contact</h1>
            </div>
        </div>
        @if ($errors->any())
            <div class="row mt-3">
                <div class="col-12">
                    <div class="alert alert-danger">
                        <ul style="margin-bottom: 0">
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                </div>
            </div>
        @endif
        @if(Session::has('b_message'))
            <div class="row mt-3">
                <div class="col-12">
                    <div class="alert alert-success">
                        {{ Session::pull('b_message')}}
                    </div>
                </div>
            </div>
        @endif
        <div class="row mt-4">
            <div class="col-md-3 col-12">
                <p class="text-right">Bedrijfsnaam</p>
            </div>
            <div class="col-md-6 col-12">
                <input type="text" name="company_name" value="{{ $user->company_name }}" class="form-control" required>
            </div>
        </div>
        <div class="row mt-2">
            <div class="col-md-3 col-12">
                <p class="text-right">E-mail</p>
            </div>
            <div class="col-md-6 col-12">
                <input type="text" name="email" value="{{ $user->email }}" class="form-control" required>
            </div>
        </div>
        <div class="row mt-2">
            <div class="col-md-3 col-12">
                <p class="text-right">Telefoon</p>
            </div>
            <div class="col-md-6 col-12">
                <input type="text" name="phone" value="{{ $user->phone }}" class="form-control" required>
            </div>
        </div>
        <div class="row mt-2">
            <div class="col-md-3 col-12">
                <p class="text-right">Bericht</p>
            </div>
            <div class="col-md-6 col-12">
                <textarea name="description" class="form-control" required rows="5">{!! old('description') !!}</textarea>
            </div>
        </div>

        <div class="row mt-4">
            <div class="col-md-3 col-12"></div>
            <div class="col-md-6 col-12">
                <button class="btn btn-sm btn-outline-primary">Versturen</button>
            </div>
        </div>
    </form>
@endsection
