@extends('layouts.app')

@section('content')
    <form id="b-card-body-content" method="POST" action="{{ route('post_login') }}">
        @csrf
        <div class="row">
            <div class="col-12">
                <h1 class="title-page">Login</h1>
            </div>
            <div class="col-12">
                <p class="b-font-bolder">Dit is de website voor de aangifte recyclingbijdrage vlakglas.</p>
            </div>
            <div class="col-12">
                <p>Log in met uw gebruikersnaam en wachtwoord welke u voor opgave van de recyclingbijdrage heeft ontvangen.</p>
            </div>
        </div>
        @if ($errors->any())
            <div class="row mt-2">
                <div class="col-12">
                    <div class="alert alert-danger">
                        <ul style="margin-bottom: 0">
                            <li>Aanmelding mislukt - Ongeldige gebruikersnaam of wachtwoord?</li>
                        </ul>
                    </div>
                </div>
            </div>
        @endif
        <div class="row">
            <div class="col-md-3 col-12">
                <p>Gebruikersnaam</p>
            </div>
            <div class="col-md-4 col-12">
                <input type="text" name="user_name" value="{{ old('user_name') }}" class="form-control" required>
            </div>
        </div>
        <div class="row mt-2">
            <div class="col-md-3 col-12">
                <p>Wachtwoord</p>
            </div>
            <div class="col-md-4 col-12">
                <input type="password" name="password" class="form-control" required>
            </div>
        </div>
        <div class="row mt-3">
            <div class="col-12">
                <button class="btn btn-sm btn-outline-primary">Aanmelden</button>
                <a href="{{ route('forgot') }}" style="margin-left: 30px">Wachtwoord vergeten?</a>
            </div>
        </div>
        <div class="row mt-3">
            <div class="col-12">
                <p>
                    Indien u vragen heeft, kunt u contact opnemen met
                    <a href="mailto:info@oavaangifte.nl">info@oavaangifte.nl</a>
                </p>
            </div>
        </div>
        <div class="row mt-3">
            <div class="col-12">
                <p class="b-mb-2">Onafhankelijke Administratie Vlakglas (OAV)</p>
                <p class="b-mb-2">p/a Stichting Fonds Vlakglas Recycling Nederland</p>
                <p class="b-mb-2">Postbus 340</p>
                <p class="b-mb-2">2700 AH Zoetermeer</p>
                <p class="b-mb-2">Tel. 088-567 88 05</p>
                <p class="b-mb-2">info@oavaangifte.nl</p>
                <p class="b-mb-2">IBAN NL10RABO0322436605</p>
            </div>
        </div>
    </form>
@endsection
