@extends('layouts.color_admin.default')
@section('title', 'Q&A')
@push('css')
<link rel="stylesheet" href="/admin_asset/css/summernote/summernote.css">
@endpush
@section('content')
    <div class="a-page-content">
        <div class="breadcomb-area">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                        <div class="breadcomb-list">
                            <form method="post" action="{{ route('admin.menu.changeQA') }}">
                                @csrf
                                <div class="row">
                                    <div class="col-12" style="padding-left: 30px">
                                        <h3>Q&A</h3>
                                    </div>
                                </div>

                                @if ($errors->any())
                                    <div class="row mt-3">
                                        <div class="col-12">
                                            <div class="alert alert-danger">
                                                <ul style="margin-bottom: 0">
                                                    @foreach ($errors->all() as $error)
                                                        <li>{{ $error }}</li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                @endif

                                @if(Session::has('b_a_email'))
                                    <div class="row mt-3">
                                        <div class="col-12">
                                            <div class="alert alert-success">
                                                {{ Session::pull('b_a_email')}}
                                            </div>
                                        </div>
                                    </div>
                                @endif

                                <div class="row">
                                    <div class="col-md-2 col-12 text-center a-mt-15">
                                        <span class="a-title-adjust">Inhoud</span>
                                    </div>
                                    <div class="col-12 col-md-8  a-mt-15">
                                        <textarea class="html-editor" name="content">{!! old('text', $qa->content) !!}</textarea>
                                    </div>
                                </div>

                                <div class="row a-mt-15">
                                    <div class="col-md-2 col-12 text-center a-mt-15"></div>
                                    <div class="col-md-8 text-right col-12">
                                        <button class="btn btn-primary btn-sm">Opslaan</button>
                                        <a href="#!" onclick="history.go(-1)" class="btn btn-danger btn-md">Annuleer</a>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
<script src="/admin_asset/js/summernote/summernote-updated.min.js"></script>
    <script>
        $(function () {
            var pathname = window.location.pathname;
            var menuItem = $('a[href="/admin/menu"]').closest('li');
			menuItem.addClass('active');
            menuItem.closest('li.has-sub').addClass('active');

            let _page = $('.a-page-content');

            $(".html-editor").summernote({
                height: 400
            })
        })
    </script>
@endpush
