@extends('layouts.color_admin.default')
@section('title', 'Inloggen als')
@push('css')
<link href="/admin_asset/css/select2.min.css" rel="stylesheet" />
@endpush
@section('content')
    <div class="a-page-content">
        <div class="breadcomb-area">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                        <div class="breadcomb-list">
                            <form method="post" action="{{ route('admin.login.loginAction') }}">
                                @csrf
                                <div class="row">
                                    <div class="col-12" style="padding-left: 30px">
                                        <h3>Inloggen als</h3>
                                    </div>
                                </div>

                                @if ($errors->any())
                                    <div class="row mt-3 mb-3">
                                        <div class="col-12">
                                            <div class="alert alert-danger">
                                                <ul style="margin-bottom: 0">
                                                    @foreach ($errors->all() as $error)
                                                        <li>{{ $error }}</li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                @endif
                                <div class="row">
                                    <div class="col-md-2 col-12 text-center a-mt-15">
                                        <span class="a-title-adjust">OAV NUMMER</span>
                                    </div>
                                    <div class="col-12 col-md-3 has-error a-mt-15">
                                        <select id="input-select2" name="id" style="width: 100%"></select>
                                    </div>
									<div class="col-md-6 text-left col-12" style="padding: 17px;">
                                        <button class="btn btn-primary btn-sm">Inloggen</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
<script src=" /admin_asset/js/select2.min.js"></script>
<script>
    $(function () {
        let _page = $('.a-page-content');

        $('#input-select2').select2({
            ajax: {
                url: "{{ route('admin.home.ajaxGetUser') }}",
                dataType: 'json',
                delay: 350,
                data: function (params) {
                    return {
                        q: params.term,
                        page: params.page
                    };
                },
                processResults: function (data, params) {
                    params.page = params.page || 1;
                    console.log(data);
                    return {
                        results: data.data,
                        pagination: {
                            more: (params.page * 20) < data.total
                        }
                    };
                }
            },
            placeholder: 'OAV NUMMER',
            minimumInputLength: 1
        });
    })
</script>  
@endpush
