@extends('layouts.color_admin.default')
@section('title', 'Beheerders')

@section('content')
    <div class="a-page-content">
        <div class="normal-table-area">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                        <form action="" method="GET">
                            <div class="normal-table-list">
                                <div class="basic-tb-hd a-header-content">
                                    <h2>Beheerders</h2>
                                    <button class="btn btn-primary btn-sm a-style-btn-crt" type="submit" name="confrim">RUN</button>
                                </div>
                                <div class="bsc-tbl">
                                    <table class="table table-striped table-sc-ex">
                                        <thead>
                                        <tr>
                                            <th>oav_number</th>
                                            <th>first_name</th>
                                            <th>email</th>
                                            <th>company_name</th>
                                            <th>address - postcode - place - land</th>
                                            <th>phone</th>
                                            <th>kvk_number / btw_number</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @forelse($list as $key => $item)
                                            <tr>
                                                <td>{{ $item->oav_number }}</td>
                                                <td>{{ $item->first_name }}</td>
                                                <td>{{ $item->email }}</td>
                                                <td>{{ $item->company_name }}</td>
                                                <td>{{ $item->address }} - {{ $item->postcode }} - {{ $item->place }} - {{ $item->land }}</td>
                                                <td>{{ $item->phone }}</td>
                                                <td>{{ ($item->kvk_number) ? $item->kvk_number : '-' }} / {{ ($item->btw_number) ? $item->btw_number : '-' }}</td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="5" class="text-center">Geen data.</td>
                                            </tr>
                                        @endforelse
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
<script>
    $(function () {
        let _page = $('.a-page-content');

        _page.on('click', '.delete-ad', function () {
            let _confirm = confirm("Delete selected admin?");
            if(_confirm){
                let _data = {
                    id: $(this).attr('data-id')
                };
                $.ajax({
                    url: "{{ route('admin.admin.delete') }}",
                    type: "POST",
                    data: _data
                }).done(function(res) {
                    if(res.status == 'success'){
                        alert('delete admin is successful');
                        window.location = location.href;
                    }
                });
            }
        })
    });
</script>
@endpush

