@extends('layouts.color_admin.default')
@section('title', 'Gebruiker')
@section('content')
    <div class="a-page-content">
        <div class="breadcomb-area">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                        <div class="breadcomb-list">
                            <form method="post" action="{{ route('admin.home.store') }}">
                                @csrf
                                <input type="hidden" name="mode" value="1">
                                <input type="hidden" name="id" value="{{ empty($user->id) ? 0 : $user->id }}">
                                <div class="row">
                                    <div class="col-12" style="padding-left: 30px">
                                        <h3>Gebruiker</h3>
                                    </div>
                                </div>

                                @if ($errors->any())
                                    <div class="row a-mt-15">
                                        <div class="col-12">
                                            <div class="alert alert-danger">
                                                <ul style="margin-bottom: 0">
                                                    @foreach ($errors->all() as $error)
                                                        <li>{{ $error }}</li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                @endif
                                @if(Session::has('a_u_message'))
                                    <div class="row a-mt-15">
                                        <div class="col-12">
                                            <div class="alert alert-success">
                                                {{ Session::pull('a_u_message')}}
                                            </div>
                                        </div>
                                    </div>
                                @endif

                                {{-- <div class="row a-mt-30">
                                    <div class="col-md-3 col-12">
                                        <p>Bedrijfsnaam</p>
                                    </div>
                                    <div class="col-md-6 col-12">
                                        <input type="text" value="{{ old('', $user->user_name) }}" name="user_name" class="form-control" @if(!empty($user->id)) readonly @endif>
                                    </div>
                                </div> --}}

                                @if (!$userUpdate->email)
                                    <div class="row a-mt-15">
                                        <div class="col-md-3 col-12">
                                            <p>OAV E-mailadres</p>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <input type="text" value="{{ $user->email }}" name="email" class="form-control" @if(!empty($user->id)) @endif>
                                        </div>
                                    </div>
                                @else
                                    <div class="row a-mt-15">
                                        <div class="col-md-3 col-12">
                                            <p>OAV E-mailadres</p>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <input type="text" value="{{ $user->email }}" class="form-control" @if(!empty($user->id)) readonly @endif>
                                        </div>
                                    </div>

                                    <div class="row a-mt-15">
                                        <div class="col-md-3 col-12">
                                            <p>Nieuw OAV E-mailadres</p>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <input type="text" value="{{ old('email', $userUpdate->email) }}" name="email" class="form-control" @if(!empty($user->id)) @endif>
                                        </div>
                                    </div>
                                @endif

                                <div class="row a-mt-15">
                                    <div class="col-md-3 col-12">
                                        <p>OAVnummer</p>
                                    </div>
                                    <div class="col-md-6 col-12">
                                        <input type="text" value="{{ old('oav_number', $user->oav_number) }}" name="oav_number" class="form-control" @if(!empty($user->id)) readonly @endif>
                                    </div>
                                </div>
                                <div class="row a-mt-15">
                                    <div class="col-md-3 col-12">
                                        <p>Bedrijfsnaam</p>
                                    </div>
                                    <div class="col-md-6 col-12">
                                        <input type="text" name="company_name" value="{{ old('company_name',$userUpdate->company_name) }}" class="form-control">
                                    </div>
                                </div>
								<div class="row a-mt-15">
                                    <div class="col-md-3 col-12">
                                        <p>Contactpersoon</p>
                                    </div>
                                    <div class="col-md-6 col-12">
                                        <input type="text" name="contact_persoon" value="{{ $userUpdate->contact }}" class="form-control">
                                    </div>
                                </div>
                                <div class="row a-mt-15">
                                    <div class="col-md-3 col-12">
                                        <p>Adres</p>
                                    </div>
                                    <div class="col-md-6 col-12">
                                        <input type="text" name="address" value="{{ old('address', $userUpdate->address) }}" class="form-control">
                                    </div>
                                </div>
                                <div class="row a-mt-15">
                                    <div class="col-md-3 col-12">
                                        <p>Postcode</p>
                                    </div>
                                    <div class="col-md-6 col-12">
                                        <input type="text" name="postcode" value="{{ old('postcode', $userUpdate->postcode) }}" class="form-control">
                                    </div>
                                </div>
                                <div class="row a-mt-15">
                                    <div class="col-md-3 col-12">
                                        <p>Plaats</p>
                                    </div>
                                    <div class="col-md-6 col-12">
                                        <input type="text" name="place" value="{{ old('place', $userUpdate->place) }}" class="form-control">
                                    </div>
                                </div>
                                <div class="row a-mt-15">
                                    <div class="col-md-3 col-12">
                                        <p>Land</p>
                                    </div>
                                    <div class="col-md-6 col-12">
                                        <!--<input type="text" name="land" value="{{ old('land', $userUpdate->land) }}" class="form-control">-->
										<select name="land" class="form-control">
											<option value="NL" <?php echo $userUpdate->land == "NL"? 'selected' : '' ?>>NL</option>
											<option value="BE" <?php echo $userUpdate->land == "BE"? 'selected' : '' ?>>BE</option>
											<option value="DE" <?php echo $userUpdate->land == "DE"? 'selected' : '' ?>>DE</option>
											<option value="HU" <?php echo $userUpdate->land == "HU"? 'selected' : '' ?>>HU</option>
										</select>
                                    </div>
                                </div>
                                <div class="row a-mt-15">
                                    <div class="col-md-3 col-12">
                                        <p>Telefoon</p>
                                    </div>
                                    <div class="col-md-6 col-12">
                                        <input type="text" name="phone" value="{{ old('phone', $userUpdate->phone) }}" class="form-control">
                                    </div>
                                </div>
                                <div class="row a-mt-15">
                                    <div class="col-md-3 col-12">
                                        <p>Fax</p>
                                    </div>
                                    <div class="col-md-6 col-12">
                                        <input type="text" name="fax" value="{{ old('fax', $userUpdate->fax) }}" class="form-control">
                                    </div>
                                </div>
                                <div class="row a-mt-15">
                                    <div class="col-md-3 col-12">
                                        <p>KvK nummer</p>
                                    </div>
                                    <div class="col-md-6 col-12">
                                        <input type="text" name="kvk_number" value="{{ old('kvk_number', $userUpdate->kvk_number) }}" class="form-control">
                                    </div>
                                </div>
                                <div class="row a-mt-15">
                                    <div class="col-md-3 col-12">
                                        <p>BTW nummer</p>
                                    </div>
                                    <div class="col-md-6 col-12">
                                        <input type="text" name="btw_number" value="{{ old('btw_number', $userUpdate->btw_number) }}" class="form-control">
                                    </div>
                                </div>
                                <div class="row a-mt-45">
                                    <div class="col-md-3 col-12"></div>
                                    <div class="col-md-6 col-12 text-right">
                                        <a href="#!" onclick="window.history.go(-1); return false;" class="btn btn-default btn-sm">« Terug </a>
                                        <button class="btn btn-primary btn-sm">Opslaan</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        $(function () {
            var pathname = window.location.pathname;
            var menuItem = $('a[href="/admin"]').closest('li');
			menuItem.addClass('active');
            menuItem.closest('li.has-sub').addClass('active');


            let _page = $('.a-page-content');
            $('#datetimepicker1').datepicker({ dateFormat: 'yy-mm-dd' });
        })
    </script>
@endpush
