@extends('layouts.color_admin.default')
@section('title', 'E-mail')

@push('css')
<link rel="stylesheet" href="/admin_asset/css/summernote/summernote.css">
@endpush
@section('content')
    <div class="a-page-content">
        <div class="breadcomb-area">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                        <div class="breadcomb-list">
                            <form method="post" action="{{ route('admin.email.saveMail') }}">
                                @csrf
                                <div class="row">
                                    <div class="col-12" style="padding-left: 30px">
                                        <h3>Update E-mail Template</h3>
                                    </div>
                                </div>
                                <input type="hidden" name="id" value="{{ $mail->id }}">

                                @if ($errors->any())
                                    <div class="row mt-3">
                                        <div class="col-12">
                                            <div class="alert alert-danger">
                                                <ul style="margin-bottom: 0">
                                                    @foreach ($errors->all() as $error)
                                                        <li>{{ $error }}</li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                @endif

                                @if(Session::has('b_a_email'))
                                    <div class="row mt-3">
                                        <div class="col-12">
                                            <div class="alert alert-success">
                                                {{ Session::pull('b_a_email')}}
                                            </div>
                                        </div>
                                    </div>
                                @endif

                                <div class="row">
                                    <div class="col-md-2 col-12 text-center a-mt-15">
                                        <span class="a-title-adjust">Template Name</span>
                                    </div>
                                    <div class="col-md-8 col-12 a-mt-15">
                                        <input class="form-control" name="name" value="{{ old('name', $mail->name) }}" required>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-2 col-12 text-center a-mt-15">
                                        <span class="a-title-adjust">Subject</span>
                                    </div>
                                    <div class="col-12 col-md-8  a-mt-15">
                                        <input type="text" class="form-control" name="title" value="{{ old('title', $mail->title) }}" required>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-2 col-12 text-center a-mt-15">
                                        <span class="a-title-adjust">Text</span>
                                    </div>
                                    <div class="col-12 col-md-8  a-mt-15">
                                        <textarea class="html-editor" name="text">{!! old('text', $mail->text) !!}</textarea>
{{--                                        <div class="html-editor">{!! old('text', $mail->text) !!}</div>--}}
{{--                                        <textarea class="form-control" name="text" rows="7">{!! old('text', $mail->text) !!}</textarea>--}}
                                        <p>{{ $mail->variables }}</p> ::oav_number:: ::company_name:: ::maand::
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-2 col-12 text-center a-mt-15">
                                        <span class="a-title-adjust">Button text</span>
                                    </div>
                                    <div class="col-12 col-md-8  a-mt-15">
                                        <input type="text" class="form-control" name="button" value="{{ old('button', $mail->button) }}">
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-2 col-12 text-center a-mt-15">
                                        <span class="a-title-adjust">CC E-mail</span>
                                    </div>
                                    <div class="col-12 col-md-8  a-mt-15">
                                        <textarea class="form-control" name="cc_email" rows="3">{!! old('cc_email', $mail->cc_email) !!}</textarea>
                                        <p>gescheiden door komma</p>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-2 col-12 text-center a-mt-15">
                                        <span class="a-title-adjust">Bcc E-mail</span>
                                    </div>
                                    <div class="col-12 col-md-8  a-mt-15">
                                        <textarea class="form-control" name="bcc_email" rows="3">{!! old('bcc_email', $mail->bcc_email) !!}</textarea>
                                        <p>gescheiden door komma</p>
                                    </div>
                                </div>
                                <div class="row a-mt-45">
                                    <div class="col-md-2 col-12 text-center a-mt-15"></div>
                                    <div class="col-md-8 text-right col-12">
                                        <button class="btn btn-primary btn-sm">Opslaan</button>
										<button class="btn btn-danger" onclick="javascript:history.go(-1);">Annuleer</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection


@push('scripts')
    <script src="/admin_asset/js/summernote/summernote-updated.min.js"></script>
    <script>
        $(function () {
            let _page = $('.a-page-content');

            $(".html-editor").summernote({
                height: 220
            })

            var pathname = window.location.pathname;
            var menuItem = $('a[href="/admin/mailTemplate"]').closest('li');
			menuItem.addClass('active');
            menuItem.closest('li.has-sub').addClass('active');
        });
    </script>
@endpush
