@extends('layouts.admin', ['title' => 'Log In'])

@section('content')
    
    <div class="login-content">
        <form method="post" action="{{ route('admin.login') }}" class="nk-block toggled" id="l-login">
            @csrf
            <div class="nk-form">
                <div class="logo text-center">
                    <img src="/images/OAV_logo.png" class="img-responsive">
                </div>

                @if($errors->any())
                    <div class="input-group">
                        <div class="alert alert-danger">
                            <ul style="margin-bottom: 0">
                                <li>Aanmelding mislukt - account niet geactiveerd of gebruikersnaam of wachtwoord ongeldig?</li>
                            </ul>
                        </div>
                    </div>
                @endif
                <div class="input-group">
                    <span class="input-group-addon nk-ic-st-pro"><i class="notika-icon notika-support"></i></span>
                    <div class="nk-int-st">
                        <input type="text" class="form-control" placeholder="e-mail" name="email" value="{{ old('email') }}">
                    </div>
                </div>
                <div class="input-group mg-t-15">
                    <span class="input-group-addon nk-ic-st-pro"><i class="notika-icon notika-edit"></i></span>
                    <div class="nk-int-st">
                        <input type="password" name="password" class="form-control" placeholder="Wachtwoord" >
                    </div>
                </div>
                <div class="fm-checkbox">
                    <label><input type="checkbox" name="remember" class="i-checks"> <i></i> Houd me aangemeld</label>
                </div>
                <button type="submit" class="btn btn-login btn-success btn-float">
                    <i class="notika-icon notika-right-arrow right-arrow-ant"></i>
                </button>
            </div>
            <div class="nk-navigation nk-lg-ic">
                <a href="#" data-ma-action="nk-login-switch" data-ma-block="#l-forget-password"><i>?</i> <span>Wachtwoord vergeten</span></a>
            </div>
        </form>

        <!-- Forgot Password -->
        <div class="nk-block" id="l-forget-password">
            <div class="nk-form">
                <p class="text-left">Recover your password.</p>
                <div class="input-group">
                    <span class="input-group-addon nk-ic-st-pro"><i class="notika-icon notika-mail"></i></span>
                    <div class="nk-int-st">
                        <input type="text" class="form-control" placeholder="E-mail" id="email-change-password">
                    </div>
                </div>
                <span class="btn btn-login btn-success btn-float" id="change-password"><i class="notika-icon notika-right-arrow"></i></span>
            </div>

            <div class="nk-navigation nk-lg-ic rg-ic-stl">
                <a href="" data-ma-action="nk-login-switch" data-ma-block="#l-login"><i class="notika-icon notika-right-arrow"></i> <span>Inloggen</span></a>
            </div>
        </div>
    </div>
@endsection

@section('js')
    <script>
        $(function () {
            let _page = $('.login-content');

            _page.on('click', '#change-password', function () {
                var _email = $('#email-change-password').val().trim();
                if(_email !== ""){
                    $.ajax({
                        url: "{{ route('admin.forgotPassword') }}",
                        data: {email: _email},
                        type: 'post',
                        success: function(res){
                            if(res.status == "success"){
                                alert(res.message);
                                window.location = res.url;
                            } else {
                                alert(res.message);
                            }
                        }
                    });
                }
            })
        })
    </script>
@endsection
