<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddKgColumnsToDeclarationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('declarations', function (Blueprint $table) {
            $table->decimal('pro_nl_kg', 15, 2)->nullable();
            $table->decimal('imp_be_kg', 15, 2)->nullable();
            $table->decimal('imp_de_kg', 15, 2)->nullable();
            $table->decimal('imp_po_kg', 15, 2)->nullable();
            $table->decimal('imp_turk_kg', 15, 2)->nullable();
            $table->decimal('import_kg', 15, 2)->nullable();
        }); 
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('declarations', function (Blueprint $table) {
            $table->dropColumn([
                'pro_nl_kg',
                'imp_be_kg',
                'imp_de_kg',
                'imp_po_kg',
                'imp_turk_kg',
                'import_kg',
            ]);
        });
    }
}
