<?php

namespace App\Models;

use App\Models\User;
use App\Models\Period;
use App\Helper\AppConstant;
use Illuminate\Database\Eloquent\Model;
use App\Models\UserPeriod;
use Illuminate\Support\Facades\DB;

class UserPeriod extends Model
{
    const STATUS_PENDING = 0;
    const STATUS_CREATED = 1;
    const STATUS_NONE = 2;
    const TYPE_YEAR = 2;
    const TYPE_QUARTER = 1;
    const TYPE_CREDITMEMO = 3;
    protected $fillable = [
        'user_id',
        'period_id',
        'status',
        'name',
        'place',
        'phone',
        'admin_updated_at',
        'user_import_id',
        'period_import_id'
    ];

    protected $casts = [
        'admin_updated_at' => 'datetime'
    ];

    public function getListFilled($userId, $orderBy = 'position')
    {
        $query = $this->join('periods', 'periods.id', '=', 'user_periods.period_id')
            ->selectRaw("
                periods.type,
                periods.period,
                periods.description,
                user_periods.id,
                user_periods.file_ubl_name,
                user_periods.agree_on_creditmemo,
                user_periods.file_pdf_credit_memo_as_gree,
				periods.position
            ")
            ->where('user_periods.user_id', $userId)
            ->whereRaw("(user_periods.status = " . self::STATUS_CREATED . " OR user_periods.status = " . self::STATUS_NONE . ")")
            ->orderBy("periods.$orderBy", 'desc');
        return $query->get();
    }

    public function getListNoninvoice($userId)
    {
        //Check if user has declaration
        $query = $this->join('periods', 'periods.id', '=', 'user_periods.period_id')
            ->selectRaw("
                periods.type,
                periods.period,
                periods.description,
                user_periods.id,
				periods.position
            ")
            ->where('user_periods.user_id', $userId)
            ->where('user_periods.status', self::STATUS_NONE)
            ->orderBy('periods.position', 'desc');
        return $query->get();
    }
    public function getCertificationList($userId)
    {
        $crY = date('Y') - 1;
        $query = DB::table('user_periods')->select('periods.group_period',            'periods.next_period',            DB::raw('SUBSTRING(file_pdf_name, 1, 6) AS ct_period_name'),            DB::raw('SUBSTRING(file_pdf_name, 1, 4) AS ct_period_year'),            DB::raw('COUNT(SUBSTRING(file_pdf_name, 1, 6)) AS ct_period_name_count'))->join('periods', 'user_periods.period_id', '=', 'periods.id')->where('user_id', $userId)->whereNotNull('file_pdf_name')->whereRaw('SUBSTRING(file_pdf_name, 1, 4) >= ' . $crY)->groupBy('ct_period_year')->havingRaw('ct_period_name_count >= 4')->orderBy('ct_period_year', 'desc')->get();
        return $query;
    }
    /**
     * Check if user has period of year disable all Q1,2,3,4
     * @param [type] $userId
     * @author X-Dev 
     * @return void
     */
    protected function userHasDeclaredOfYear($userId)
    {
        $arrayDetect = array(
            "year" => false,
            "quarter" => false
        );
        #YEAR
        //Eloquent data
        $builderPeriodOfYear = $this->join('periods', 'periods.id', '=', 'user_periods.period_id')
            ->where("user_id", "=", $userId)
            ->where("status", "=", self::STATUS_CREATED)
            ->where("periods.type", "=", self::TYPE_YEAR)->selectRaw("user_periods.period_id");
        //Collection Object
        $collectionPeriodOfYear = $builderPeriodOfYear->get();
        if (count($collectionPeriodOfYear) > 0) {
            $arrayDetect["year"] = true;
        }
        #QUARTER
        $builderPeriodOfQuater = $this->join('periods', 'periods.id', '=', 'user_periods.period_id')
            ->where("user_id", "=", $userId)
            ->where("status", "=", self::STATUS_CREATED)
            ->where("periods.type", "=", self::TYPE_QUARTER)->selectRaw("user_periods.period_id");
        //Collection Object
        $collectionPeriodOfQuater = $builderPeriodOfQuater->get();
        if (count($collectionPeriodOfQuater) > 0) {
            $arrayDetect["quarter"] = true;
        }
        return $arrayDetect;
    }
    /**
     *  Get list pending period to make decleration
     * @param [type] $userId
     * @author X-Dev
     * @return void
     */
    public function getListUnfill($userId)
    {
        //Check if user has declaration
        $this->_modelUserPeriod = new UserPeriod();
        $arrayDetect = $this->_modelUserPeriod->userHasDeclaredOfYear($userId);
        $hasYear = $arrayDetect["year"];
        $hasQuater = $arrayDetect["quarter"];
        $collection = null;

        $hasYear = false;
        $hasQuater = false;
        if ($hasYear == false) {
            //Check Q1,Q2,Q3,Q4 if user start in Q1 it must be hide Q5
            $query = $this->join('periods', 'periods.id', '=', 'user_periods.period_id')
                ->where('user_periods.user_id', $userId)
                ->where('user_periods.status', self::STATUS_PENDING)
                ->whereIn('periods.type', [self::TYPE_YEAR, self::TYPE_QUARTER, AppConstant::PERIOD_TYPE_MONTH])
                ->where('periods.period', "not like", "%Q6%");
            $query = $query->selectRaw("
                periods.id,
                periods.period,
                periods.type,
                periods.description,
                periods.date_release,
				user_periods.status,
                user_periods.id as dec_id
            ");
            $collection = $query->get();
        } else {
            $collection = [];
        }
        return $collection;
    }



    public function getListForAdmin($start, $limit, $search)
    {
        $query = $this->whereIn('user_periods.status', [1, 2])
            ->join('periods', 'periods.id', '=', 'user_periods.period_id')
            ->join('users', 'users.id', '=', 'user_periods.user_id')
            ->selectRaw("
                periods.id,
                periods.period,
                periods.type,
                periods.description,
                user_periods.status,
                user_periods.file_pdf_name,
                user_periods.agree_on_creditmemo,
                user_periods.admin_updated_at,
                user_periods.created_at,
                user_periods.updated_at as declare_date,
                user_periods.id,
                users.user_name,
                users.oav_number,
                users.company_name,
                users.id as user_id
            ");
        if ($search) {
            $query->where('users.company_name', 'like', "%{$search}%");
            $query->orWhere('users.oav_number', 'like', "%{$search}%");
            $query->orWhere('periods.period', 'like', "%{$search}%");
            $query->orWhere('user_periods.file_pdf_name', 'like', "%{$search}%");
            /*->orWhere('users.company_name','like',"%{$search}%")
                ->orWhere('periods.period','like',"%{$search}%")
                ->orWhere('periods.description','like',"%{$search}%");*/
        }

        if ($start || $limit) {
            $query->offset($start)->limit($limit);
        }

        $query->whereIn('user_periods.status', [1, 2]);
        //$query->orderBy('user_periods.updated_at', 'desc');
        return $query;
    }

    public function getListInvoiceAdmin()
    {
        $query = $this->join('periods', 'periods.id', '=', 'user_periods.period_id')
            ->join('users', 'users.id', '=', 'user_periods.user_id')
            ->selectRaw("
                periods.period,
                periods.type,
                periods.description,
                user_periods.file_pdf_name,
                user_periods.admin_updated_at,
                user_periods.created_at,
                user_periods.updated_at as declare_date,
                user_periods.id,
                users.user_name,
                users.oav_number,
                users.company_name,
                users.id as user_id
            ")
            ->where('user_periods.status', self::STATUS_NONE)
            ->orderBy('periods.id', 'desc');
        return $query->get();
    }
    public function getListQ6($year)
    {
        $query = $this->join('periods', 'periods.id', '=', 'user_periods.period_id')
            ->join('users', 'users.id', '=', 'user_periods.user_id')
            ->selectRaw("
                periods.period,
                periods.type,
                periods.description,
                user_periods.file_pdf_name,
                user_periods.admin_updated_at,
                user_periods.id,
                users.user_name
            ")
            ->where('user_periods.status', self::STATUS_CREATED)
            ->where('periods.period', "=", $year . " Q6")
            ->orderBy('periods.id', 'desc');
        return $query->get();
    }
    public function getDetailForAdmin($id)
    {
        $query = $this->where('user_periods.id', $id)
            /*->where('user_periods.status', UserPeriod::STATUS_CREATED)*/
            ->join('periods', 'periods.id', '=', 'user_periods.period_id')
            ->join('users', 'users.id', '=', 'user_periods.user_id')
            ->join('declarations', 'declarations.user_period_id', '=', 'user_periods.id')
            ->join('declaration_types', 'declaration_types.id', '=', 'declarations.type_id')
            ->selectRaw("
                user_periods.user_id,
                user_periods.id,
                user_periods.name,
                user_periods.place,
                user_periods.phone,
                declarations.id as des_id,
                declarations.status,

                declarations.pro_nl,
                declarations.pro_nl_kg,
                declarations.imp_be,
                declarations.imp_be_kg,
                declarations.imp_de,
                declarations.imp_de_kg,
                declarations.imp_po,
                declarations.imp_po_kg,
                declarations.imp_turk,
                declarations.imp_turk_kg,
                declarations.import,
                declarations.import_kg,

                declarations.unit_price,
                declarations.total,
                declarations.total_m2,
                declarations.btw,
                declarations.total_btw,
                declarations.type_id,
                declaration_types.category_id,
                declaration_types.name as type_name,
                users.user_name,
                periods.period
            ")
            ->orderBy('declaration_types.id');
        return $query->get();
    }


    public function getListUnfilled($periodId)
    {
        $query = $this->where('user_periods.period_id', $periodId)
            ->join('users', 'users.id', '=', 'user_periods.user_id')
            ->selectRaw("
                users.id as user_id,
                users.user_name,
                users.company_name,
                users.oav_number,
                users.email,
                users.address,
                user_periods.status
            ");
        /* ->where('user_periods.status', UserPeriod::STATUS_PENDING); */
        return $query->get();
    }
    /**
     * Function get user submited declaration
     *
     * @param [type] $periodId
     * @return void
     */
    public function getListFilledForQ6($periodId)
    {
        $query = $this->where('user_periods.period_id', $periodId)
            ->join('users', 'users.id', '=', 'user_periods.user_id')
            ->selectRaw("
                users.id as user_id,
                users.user_name,
                users.company_name,
                users.oav_number,
                users.email,
                users.address,
                user_periods.status
            ")->where('user_periods.status', UserPeriod::STATUS_PENDING);
        return $query->get();
    }
    public function getListUnfilledOfPeriod($periodId)
    {
        $query = $this->where('user_periods.period_id', $periodId)
            ->join('users', 'users.id', '=', 'user_periods.user_id')
            ->selectRaw("
                users.id as user_id,
                users.user_name,
                users.company_name,
                users.oav_number,
                users.email,
                users.address,
                user_periods.status
            ")->where('user_periods.status', UserPeriod::STATUS_PENDING);

        return $query->get();
    }
    /**
     *  Get list credit memo period to make decleration
     * @param [type] $userId
     * @author X-Dev
     * @return void
     */
    public function getListCreditMemo($userId, $status = '')
    {
        //Check if user has declaration
        $this->_modelUserPeriod = new UserPeriod();
        $collection = null;
        $query = $this->join('periods', 'periods.id', '=', 'user_periods.period_id')
            ->where('user_periods.user_id', $userId)
            ->where("periods.type", "=", self::TYPE_CREDITMEMO);

        if ($status !== '') {
            $query->where('user_periods.status', $status);
        }
        $query = $query->selectRaw("
            periods.id,
            periods.period,
            periods.type,
            periods.description,
            periods.date_release,
            periods.group_period,
            user_periods.id as period_id,
            user_periods.status as status
        ");
        $collection = $query->get()->first();
        return $collection;
    }
    public function getListCreditMemos($userId, $status = '')
    {
        //Check if user has declaration
        $this->_modelUserPeriod = new UserPeriod();
        $collection = null;
        $query = $this->join('periods', 'periods.id', '=', 'user_periods.period_id')
            ->where('user_periods.user_id', $userId)
            ->where("periods.type", "=", self::TYPE_CREDITMEMO);

        if ($status !== '') {
            $query->where('user_periods.status', $status);
        }
        $query = $query->selectRaw("
            periods.id,
            periods.period,
            periods.type,
            periods.description,
            periods.date_release,
            periods.group_period,
            user_periods.id as period_id,
            user_periods.status as status
        ");
        $collection = $query->get();
        return $collection;
    }
    /**
     * get period id by user_period_id form declaration object
     */
    public function getPeriodId($user_period_id)
    {
        $user_period = UserPeriod::where("id", "=", $user_period_id)->first();
        return $user_period->period_id;
    }
    public function getPeriodById($user_period_id)
    {
        $user_period = UserPeriod::where("id", "=", $user_period_id)->first();
        return $user_period;
    }
    public function getPeriodData($user_period_id)
    {
        $user_period = UserPeriod::where("id", "=", $user_period_id)->first();
        return $user_period;
    }
    public function getUserPeriod($user_id, $period_id)
    {
        $user_period = UserPeriod::where("user_id", "=", $user_id)->where("period_id", "=", $period_id)->first();
        return $user_period;
    }
    public function getUserPeriodByImportId($user_id, $period_id)
    {
        $user_period = UserPeriod::where("user_import_id", "=", $user_id)->where("period_import_id", "=", $period_id)->first();
        return $user_period;
    }
    /**
     * update file_pdf_name after created file
     */
    public function updateFilePdfNameById($id, $fileName)
    {
        $userModel = UserPeriod::find($id);
        $user_period = $userModel->firstOrFail();
        if ($user_period) {
            $userModel->file_pdf_name = $fileName;
            $userModel->save();
        }
        return $user_period;
    }


    /**
     * get user_periods by user id and period id
     */
    public function getUserPeriodsByUserIdByPeriodId($userId, $periodId)
    {
        $userPeriods = UserPeriod::whereRaw('user_id = ' . $userId . ' and period_id = ' . $periodId . '')->first();
        return $userPeriods;
    }

    public function getCountNumberInPeriodIdWithPDF($periodId)
    {
        $numberPdf = UserPeriod::where("period_id", "=", $periodId)
            ->where("file_pdf_name", "!=", "")
            ->get();
        return count($numberPdf);
    }
    /**
     * update user to user periods
     */
    public function updateUser($params)
    {
        try {
            $userId = $params['user_id'];
            $periodId = $params['period_id'];
            // get user details
            $userModel = new User();
            $userDedtails = $userModel->getUserDetailsById($userId);
            if ($userDedtails) {
                $checkUserPeriods = $this->getUserPeriodsByUserIdByPeriodId($userId, $periodId);
                if (!$checkUserPeriods) {
                    $userAdd = new UserPeriod();
                    $userAdd->user_id = $userId;
                    $userAdd->period_id = $periodId;
                    $userAdd->status = 0;
                    $userAdd->name = $userDedtails->user_name;
                    $userAdd->place = $userDedtails->place;
                    $userAdd->phone = $userDedtails->phone;
                    $userAdd->save();
                }
            }
            return true;
        } catch (Exception $e) {
            return false;
        }
    }

    public function getActivePeriod($user_id, $year)
    {
        $list_of_active_user_period = UserPeriod::selectRaw('*')
            ->join('periods', 'user_periods.period_id', '=', 'periods.id')
            ->where('user_periods.user_id', $user_id)
            ->where('user_periods.status', 1)
            ->where('periods.period', "not like", "%Q6%")
            ->where('periods.group_period', "=", $year)
            ->first();
        return $list_of_active_user_period;
    }

    public function getDetailDeclarationTemp($user_period_id)
    {
        $query = $this->where('user_periods.id', $user_period_id)
            ->where('user_periods.status', 0)
            ->join('periods', 'periods.id', '=', 'user_periods.period_id')
            ->join('users', 'users.id', '=', 'user_periods.user_id')
            ->join('declaration_temps', 'declaration_temps.user_period_id', '=', 'user_periods.id')
            ->join('declaration_types', 'declaration_types.id', '=', 'declaration_temps.type_id')
            #FIX ME
            ->selectRaw("
                user_periods.user_id,
                user_periods.id,
                user_periods.name,
                user_periods.place,
                user_periods.phone,
                declaration_temps.id as des_id,
                declaration_temps.status,
                declaration_temps.pro_nl,
                declaration_temps.imp_be,
                declaration_temps.imp_de,
                declaration_temps.imp_po,
                declaration_temps.imp_turk,
                declaration_temps.import,
                declaration_temps.unit_price,
                declaration_temps.total,
                declaration_temps.total_m2,
                declaration_temps.btw,
                declaration_temps.weight,
                declaration_temps.total_btw,
                declaration_temps.type_id,
                declaration_types.category_id,
                declaration_types.name as type_name,
                users.user_name,
                periods.period
            ")
            /* ->selectRaw("*") */
            ->orderBy('declaration_types.id');

        return $query->get();
    }

    public function getYearOfPeriod($id)
    {
        $year = UserPeriod::where("user_periods.id", "=", $id)
            ->join('periods', 'periods.id', '=', 'user_periods.period_id')
            ->value('group_period');

        return (int)$year;
    }

    public function checkExistFileName($ubl_name)
    {
        try {
            return UserPeriod::where('file_ubl_name', $ubl_name)->first() ? true : false;
        } catch (\Exception $exception) {
            return false;
        }
    }
    /**
     * Auto-generate user_periods for all periods of a given year
     */
    public static function autoGenerateForUser($userId, $year)
    {
        // get all periods for this year (jaar + kwartaal + maand)
        $periods = \App\Models\Period::where('group_period', $year)->get();
        if ($periods->count() == 0) {
            return;
        }

        // get user details
        $user = \App\Models\User::find($userId);

        foreach ($periods as $p) {
            // check if already exists
            $exists = UserPeriod::where('user_id', $userId)
                ->where('period_id', $p->id)
                ->first();

            if (!$exists) {
                $up = new UserPeriod();
                $up->user_id = $userId;
                $up->period_id = $p->id;
                $up->status = self::STATUS_PENDING; // 0
                $up->name = $user->user_name ?? null;
                $up->place = $user->place ?? null;
                $up->phone = $user->phone ?? null;
                $up->save();
            }
        }
    }
}
