<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DeclarationType extends Model
{
    protected $fillable = [
        'name' , 'category_id', 'unit_price','weight', 'sort', 'is_deleted' // phmd
    ];

    public function getList(){
        return $this->paginate(config('appvalue.paging'));
    }

    /**
     * get all with category name
     */

    public function getListWithCategory(){
        $declarations = DeclarationType::join('categories','categories.id','=','declaration_types.category_id')
                                        ->selectRaw('declaration_types.*, categories.title')
                                        ->orderBy('category_id')
                                        ->orderBy('sort', 'asc') // phmd
                                        ->get();

        return $declarations;
    }
    
    public function getListWithCategoryOld(){
        $declarations = DeclarationType::join('categories','categories.id','=','declaration_types.category_id')
                                        ->selectRaw('declaration_types.*, categories.title')
                                        ->orderBy('category_id')
                                        ->get();

        return $declarations;
    }
}
