<?php

namespace App\Mail;

use App\Helper\AppConstant;
use App\Models\Period;
use App\Models\TemplateEmail;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class RemindPeriod extends Mailable
{
    use Queueable, SerializesModels;

    protected $period;
    protected $user;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(Period $period, $user = null)
    {
        $this->period = $period;
        $this->user = $user;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $template = TemplateEmail::where('id', AppConstant::MAIL_REMIND_PERIOD)->first();
        $user = $this->user;
        if(!empty($template->id)){
            $title = $template->title;
            $date_start = strtotime($this->period->date_start);
            $date_statement = strtotime($this->period->date_statement);

            $title = str_replace('::periode::', $this->period->description, $title);
            $title = str_replace('::maand::', $this->period->period, $title);
            $title = str_replace('::date_start::', date('d/m/Y', $date_start), $title);
            $title = str_replace('::date_statement::', date('d/m/Y', $date_statement), $title);
            $title = str_replace('::oav_number::',@$user->oav_number, $title);
            $title = str_replace('::company_name::',@$user->company_name, $title);

            $text = str_replace('::periode::', $this->period->description, $template->text);
            $text = str_replace('::maand::', $this->period->period, $text);
            $text = str_replace('::date_start::', date('d/m/Y', $date_start), $text);
            $text = str_replace('::date_statement::', date('d/m/Y', $date_statement), $text);
            $text = str_replace('::oav_number::',@$user->oav_number, $text);
            $text = str_replace('::company_name::',@$user->company_name, $text);
            $button = $template->button;
            $cc = explode(',', $template->cc_email);
            $bcc = explode(',', $template->bcc_email);

            $emailData = [
                'title' => $title,
                'text' => $text,
                'button' => $button,
                'url' => route('home.cma', ['id' => $this->period->id])
            ];
			
		 

            return $this->markdown('emails.template.mail')
                ->subject($title)
                ->cc(empty($cc[0]) ? [] : $cc)
                ->bcc(empty($bcc[0]) ? [] : $bcc)
                ->with($emailData);
        } else {
            return $this->markdown('emails.period.remind')
            ->with([
                'url' => route('home.cma', ['id' => $this->period->id]),
                'period' => $this->period->period
            ]);
        }

    }
}
