<?php

namespace App\Mail;

use App\Helper\AppConstant;
use App\Models\Period;
use App\Models\User;
use App\Models\Declaration;
use App\Models\TemplateEmail;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class DeclarationAdmin extends Mailable
{
    use Queueable, SerializesModels;

    protected $_oav_number;
    protected $_periode;
    protected $_place;
    protected $_date;
    protected $_name;
    protected $_phone;
    protected $_pdf_file;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($periode,$oav_number,$place,$date,$name,$phone,$pdf_file,$ubl_file = '')
    {
        $this->_oav_number = $oav_number;
        $this->_periode = $periode;
        $this->_place = $place;
        $this->_date = $date;
        $this->_name = $name;
        $this->_phone = $phone;
        $this->_pdf_file = $pdf_file;
        $this->_ubl_file = $ubl_file;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $template = TemplateEmail::where('id', AppConstant::MAIL_ADMIN_INVOICE)->first();
        if(!empty($template->id)){
            /* $title = $template->title; */
            $date_start = strtotime($this->_date);
            $maand = date('F', $date_start);

            $title = str_replace('::oav_number::', $this->_oav_number, $template->title);
            $title = str_replace('::periode::', $this->_periode, $title);
            $title = str_replace('::maand::', $maand, $title);

            $text = str_replace('::oav_number::', $this->_oav_number, $template->text);
            $text = str_replace('::place::', $this->_place, $text);
            $text = str_replace('::maand::', $maand, $text);
            $text = str_replace('::date::', date('d/m/Y', $date_start), $text);
            $text = str_replace('::name::', $this->_name, $text);
            $text = str_replace('::phone::', $this->_phone, $text);

            $button = $template->button;
            $cc = explode(',', $template->cc_email);
            $bcc = explode(',', $template->bcc_email);
			
			$markdown = $this->markdown('emails.template.mail')
                ->subject($title)
                ->cc(empty($cc[0]) ? [] : $cc)
                ->bcc(empty($bcc[0]) ? [] : $bcc);

            if( $this->_pdf_file ){
                $markdown->attach($this->_pdf_file);
            }
            if( $this->_ubl_file ){
                $markdown->attach($this->_ubl_file);
            }
 

            $markdown->with([
                    'title' => $title,
                    'text' => $text,
                    'button' => $button
            ]);

            return $markdown;

            return $this->markdown('emails.template.mail')
                ->subject($title)
                ->cc(empty($cc[0]) ? [] : $cc)
                ->bcc(empty($bcc[0]) ? [] : $bcc)
                ->attach($this->_pdf_file)
                ->attach($this->_ubl_file)
                ->with([
                    'title' => $title,
                    'text' => $text,
                    'button' => $button
                ]);
        }
    }
}
