<?php

namespace App\Mail;

use App\Helper\AppConstant;
use App\Models\ContactAdmin;
use App\Models\TemplateEmail;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class ContactAdminMail extends Mailable
{
    use Queueable, SerializesModels;

    public $contact;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(ContactAdmin $contact)
    {
        $this->contact = $contact;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $template = TemplateEmail::where('id', AppConstant::MAIL_CONTACT_ADMIN)->first();
        if(!empty($template->id)){
            $title = $template->title;
            $text = str_replace('::company_name::', $this->contact->company_name, $template->text);
            $text = str_replace('::email::', $this->contact->email, $text);
            $text = str_replace('::telephone::', $this->contact->phone, $text);
            $text = str_replace('::description::', $this->contact->description, $text);
            $button = $template->button;
            $cc = explode(',', $template->cc_email);
            $bcc = explode(',', $template->bcc_email);

            return $this->markdown('emails.template.mail')
                ->subject($title)
                ->cc(empty($cc[0]) ? [] : $cc)
                ->bcc(empty($bcc[0]) ? [] : $bcc)
                ->with([
                    'title' => $title,
                    'text' => $text,
                    'button' => $button,
                    'url' => route('admin.home.index')
                ]);
        } else {
            return $this->markdown('emails.admin.contact')
                ->with([
                    'contact' => $this->contact,
                    'url' => route('admin.home.index')
                ]);
        }

    }
}
