<?php

namespace App\Mail;

use App\Helper\AppConstant;
use App\Models\Period;
use App\Models\TemplateEmail;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class AssignPeriod extends Mailable
{
    use Queueable, SerializesModels;

    protected $period;
    protected $user;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(Period $period, $user = null)
    {
        $this->period = $period;
        $this->user = $user;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $template = TemplateEmail::where('id', AppConstant::MAIL_CREATE_DEC)->first();
        
        $title = $template->title;
        $user = $this->user;
        $title = str_replace('::oav_number::',@$user->oav_number, $title);
        $title = str_replace('::company_name::',@$user->company_name, $title);

        $date_end = strtotime($this->period->date_end);
        $periodString = $this->period->period; // e.g. "2025-10"
        $parts = explode('-', $periodString);
        $monthNumber = isset($parts[1]) ? intval($parts[1]) : date('n', $date_end); // fallback
        $dutchMonths = [
            1 => 'januari',
            2 => 'februari',
            3 => 'maart',
            4 => 'april',
            5 => 'mei',
            6 => 'juni',
            7 => 'juli',
            8 => 'augustus',
            9 => 'september',
            10 => 'oktober',
            11 => 'november',
            12 => 'december'
        ];
        $maand = $dutchMonths[$monthNumber];
        $text = str_replace('::periode::', $this->period->description, $template->text);
        $text = str_replace('::maand::', $maand, $text);
        $text = str_replace('::date_end::', date('d/m/Y', $date_end), $text);
        $text = str_replace('::oav_number::',@$user->oav_number, $text);
        $text = str_replace('::company_name::',@$user->company_name, $text);

        $button = $template->button;
        $cc = explode(',', $template->cc_email);
        $bcc = explode(',', $template->bcc_email);

        $emailData = [
            'title' => $title,
            'text' => $text,
            'button' => $button,
        ];

   

        return $this->markdown('emails.template.mail')
            ->subject($title)
            ->cc(empty($cc[0]) ? [] : $cc)
            ->bcc(empty($bcc[0]) ? [] : $bcc)
            ->with($emailData);
    }
}
