<?php


namespace App\Http\Controllers\Admin;


use App\Http\Controllers\Controller;
use App\Models\Menu;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class MenuController extends Controller
{
    public function index(){
        $list = Menu::all();

        $params = [
            'list' => $list
        ];

        return view('admin.menu.index', $params);
    }

    public function changeStatus(Request $request){
        $data = $request->all();
        $validator = Validator::make($data,[
            'id' => 'required'
        ]);
        if($validator->fails()){
            return response()->json([
                'status' => 'fail'
            ]);
        } else {
            if(empty($data['status'])){
                $status = Menu::STATUS_HIDE;
            } else {
                $status = Menu::STATUS_SHOW;
            }

            Menu::where('id', $data['id'])
                ->update([
                    'status' => $status
                ]);

            return response()->json([
                'status' => 'success'
            ]);
        }

    }

    public function qa(){
        $qa = Menu::where('name', 'qa')->firstOrFail();
        $params = [
            'qa' => $qa
        ];

        return view('admin.menu.qa', $params);
    }

    public function changeQA(Request $request){
        $content = $request->get('content');
        $patterns = [
            '/@php/i',
            '/{{/',
            '/{!!/',
            '/\<\?php/i'
        ];
        $replacements = ['', '', '', ''];

        $content = trim(preg_replace($patterns, $replacements, $content));
        Menu::where('name', 'qa')->update([
            'content' => $content
        ]);

        return redirect(route('admin.menu.qa'))
            ->with(['b_a_email' => 'opgeslagen']);
    }
}
