<?php

namespace App\Http\Controllers\Admin;

use App\Helper\AppConstant;
use App\Http\Controllers\Controller;
use App\Mail\ChangePassword;
use App\Mail\ChangeUserPass;
use App\Mail\ContactAdminMail;
use App\Mail\CreateAdmin;
use App\Mail\CreateUser;
use App\Mail\NotiAdmin;
use App\Mail\RemindPeriod;
use App\Models\ContactAdmin;
use App\Models\Period;
use App\Models\TemplateEmail;
use Illuminate\Http\Request;
use Illuminate\Mail\Markdown;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;

class EmailController extends Controller
{
    public function mailTemplate(){
        $template = new TemplateEmail();
        $list = $template->getListTemplate();

        $params = [
            'list' => $list
        ];

        return view('admin.email.template', $params);
    }

    public function mailDetail($id){
        $mail = TemplateEmail::where('id', $id)->firstOrFail();

        $params = [
            'mail' => $mail
        ];

        return view('admin.email.detail', $params);
    }

    public function saveMail(Request $request){
        $data = $request->all();
        if(empty($data['id'])){
            abort(404);
        }
        $validator = Validator::make($data, [
            'title' => 'required',
            'name' => 'required'
        ]);

        if($validator->fails()){
            return redirect(route('admin.email.mailDetail', ['id' => $data['id']]))
                ->withErrors($validator->errors())
                ->withInput();
        } else {
            $email = TemplateEmail::where('id', $data['id'])->firstOrFail();
            if(!empty($data['text'])){
                $patterns = [
                    '/@php/i',
                    '/{{/',
                    '/{!!/',
                    '/\<\?php/i'
                ];
                $replacements = ['', '', '', ''];

                $data['text'] = trim(preg_replace($patterns, $replacements, $data['text']));
            }
            $email->fill($data)->save();

            return redirect(route('admin.email.mailTemplate'))
                ->with(['b_a_email' => '"' . $email->name . '" is geupdate!']);
        }
    }

    public function previewMail($id){
        $template = TemplateEmail::where('id', $id)->firstOrFail();
        $markdown = new Markdown(view(), config('mail.markdown'));

        $params = [
            'title' => $template->title,
            'text' => $template->text,
            'url' => '#',
            'button' => $template->button
        ];

        return $markdown->render('emails.template.mail', $params);
    }
}
