<?php


namespace App\Http\Controllers\Admin;


use App\Http\Controllers\Controller;
use App\Mail\CreateUser;
use App\Models\Period;
use App\Models\User;
use App\Models\UserPeriod;
use App\Models\UserUpdate;
use App\Models\Declaration;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;

class DashboardController extends Controller
{
    public function index(){
		$user = new User();
        $list_of_declaration = Declaration::selectRaw('count(user_period_id) as number_declaration')
        ->groupBy(['user_period_id'])
        ->get();
        $list_of_user_period = UserPeriod::selectRaw('count(*) as number_assign')->where("status","=","0")->first();
		$list_of_user = count($user->getCountUser());
        $params = [
            'count_submit_declaration' => count($list_of_declaration),
			'count_user' => $list_of_user,
            'qty_send_email' => $list_of_user_period->number_assign
        ];
        return view('admin.dashboard.index', $params);
    }
}
