<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 10/22/2019
 * Time: 5:24 PM
 */

namespace App\Http\Controllers\Admin;


use App\Http\Controllers\Controller;
use App\Mail\ChangePassword;
use App\Models\Admin;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;

class AuthController extends Controller
{
    use AuthenticatesUsers;

    protected $redirectTo = '/admin/dashboard';

    public function __construct()
    {
        $this->middleware('guest:admin')->except('logout');
    }

    public function showLoginForm()
    {
        session()->forget('_previous');
        session()->forget('url.intended');
        session()->save();

        return view('admin.auth.login');
    }

    protected function guard()
    {
        return Auth::guard('admin');
    }

    public function logout()
    {
        Auth::guard('admin')->logout();
        return redirect('admin/login');
    }



    public function forgotPassword(Request $request){
        $data = $request->all();
        $validator = Validator::make($data, [
            'email' => 'required|email'
        ]);

        if($validator->fails()){
            return response()->json([
                'status' => 'fail',
                'message' => 'email is niet correct!'
            ]);
        } else {
            $admin = Admin::where('email', $data['email'])->first();
            if(empty($admin->id)){
                return response()->json([
                    'status' => 'fail',
                    'message' => 'email is niet correct!'
                ]);
            } else {
                $code = time() . Str::random(16);
                $admin->forgot_code = $code;
                $admin->save();

                Mail::to($data['email'])->queue(new ChangePassword($code));
                return response()->json([
                    'status' => 'success',
                    'message' => 'recovery code has been sent.',
                    'url' => route('admin.showLoginForm')
                ]);
            }
        }
    }

    public function showPasswordForm($code){
        $admin = Admin::where('forgot_code', $code)->firstOrFail();

        $params = [
            'code' => $code
        ];
        return view('admin.auth.password', $params);
    }

    public function changePassword(Request $request){
        $data = $request->all();
        $validator = Validator::make($data, [
            'password' => 'required',
            'retype_password' => 'required|same:password',
            'code' => 'required'
        ]);

        if($validator->fails()){
            return redirect(route('admin.password', ['code' => $data['code']]))
                ->withErrors($validator->errors());
        } else {
            $admin = Admin::where('forgot_code', $data['code'])->firstOrFail();
            $admin->password = Hash::make($data['password']);
            $admin->forgot_code = null;
            $admin->save();
            return redirect(route('admin.showLoginForm'));
        }
    }
    protected function authenticated(Request $request, $user)
    {
        return redirect()->route('admin.dashboard.index');
    }
}
